<?php
require_once '../config.php';
requireLogin();

header('Content-Type: application/json');

if (isset($_GET['id'])) {
    $client_id = intval($_GET['id']);
    
    $stmt = $conn->prepare("
        SELECT ch.*, u.full_name as action_by_name 
        FROM client_history ch 
        JOIN users u ON ch.action_by = u.id 
        WHERE ch.client_id = ? 
        ORDER BY ch.action_date DESC
    ");
    $stmt->bind_param("i", $client_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $history = [];
    while ($row = $result->fetch_assoc()) {
        $history[] = $row;
    }
    
    echo json_encode($history);
    
    $stmt->close();
} else {
    echo json_encode(['error' => 'No client ID provided']);
}
?>