<?php
?>
<!-- Simple Dashboard Button -->
<a href="dashboard.php" class="dashboard-btn">
    <i class="fas fa-tachometer-alt"></i>
    <span>Dashboard</span>
</a>



<style>
/* Main Dashboard Button Styles */
.dashboard-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 10px 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    text-decoration: none;
    border-radius: 6px;
    font-weight: 500;
    font-size: 14px;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
    box-shadow: 0 4px 6px rgba(102, 126, 234, 0.2);
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    margin-top: 30px;
    margin-left: 200px;
}

.dashboard-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(102, 126, 234, 0.3);
    background: linear-gradient(135deg, #5a6fd8 0%, #6a4190 100%);
}

.dashboard-btn:active {
    transform: translateY(0);
    box-shadow: 0 2px 4px rgba(102, 126, 234, 0.2);
}

.dashboard-btn i {
    font-size: 14px;
}

/* Outline Style */
.dashboard-btn.outline {
    background: transparent;
    border: 2px solid #667eea;
    color: #667eea;
    box-shadow: none;
}

.dashboard-btn.outline:hover {
    background: rgba(102, 126, 234, 0.1);
    color: #5a6fd8;
    border-color: #5a6fd8;
}

/* Small Version */
.dashboard-btn.small {
    padding: 6px 12px;
    font-size: 13px;
    gap: 6px;
}

.dashboard-btn.small i {
    font-size: 13px;
}

/* Large Version */
.dashboard-btn.large {
    padding: 12px 24px;
    font-size: 16px;
    gap: 10px;
}

.dashboard-btn.large i {
    font-size: 16px;
}

/* Icon Only */
.dashboard-btn.icon-only {
    width: 40px;
    height: 40px;
    padding: 0;
    border-radius: 50%;
}

.dashboard-btn.icon-only span {
    display: none;
}

.dashboard-btn.icon-only i {
    font-size: 16px;
    margin: 0;
}

/* For use in header/navbar */
.dashboard-btn.nav {
    margin: 0 10px;
    border-radius: 4px;
}

/* Button with shadow only on hover */
.dashboard-btn.flat {
    box-shadow: none;
}

.dashboard-btn.flat:hover {
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

/* Success/Green variation */
.dashboard-btn.success {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    box-shadow: 0 4px 6px rgba(16, 185, 129, 0.2);
}

.dashboard-btn.success:hover {
    background: linear-gradient(135deg, #0da271 0%, #047857 100%);
    box-shadow: 0 6px 12px rgba(16, 185, 129, 0.3);
}

/* Danger/Red variation */
.dashboard-btn.danger {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    box-shadow: 0 4px 6px rgba(239, 68, 68, 0.2);
}

.dashboard-btn.danger:hover {
    background: linear-gradient(135deg, #e11d48 0%, #be123c 100%);
    box-shadow: 0 6px 12px rgba(239, 68, 68, 0.3);
}

/* Button group (if you want multiple buttons together) */
.btn-group {
    display: inline-flex;
    gap: 10px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .dashboard-btn span {
        display: none;
    }
    
    .dashboard-btn.icon-only {
        width: 36px;
        height: 36px;
    }
    
    .dashboard-btn.icon-only i {
        font-size: 14px;
    }
}
</style>